/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.pa.ar;

import com.ibm.hwmca.base.pa.ar.CommonDataAnalysisRoutine;
import com.ibm.hwmca.base.pa.domain.ConsoleAnalysisDomain;
import com.ibm.hwmca.base.pa.event.MicroCodeDataEvent;
import com.ibm.hwmca.base.pa.incident.HmcIncident;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.fw.domain.DomainManager;
import com.ibm.hwmca.fw.log.Log;
import com.ibm.hwmca.fw.pa.event.ProblemAnalysisEvent;
import com.ibm.hwmca.fw.pa.event.ProblemAnalysisEventListener;
import com.ibm.hwmca.fw.util.HexString;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.pa.problem.CommonProblem;

public class MicroCodeAnalysisRoutine
extends CommonDataAnalysisRoutine
implements ProblemAnalysisEventListener {
    private static final String TRACE_MASKT = "XPAMCART";
    private static final String TRACE_MASKF = "XPAMCARF";
    private static final String TRACE_MASKD = "XPAMCARD";

    public MicroCodeAnalysisRoutine() {
        Trace.trace(TRACE_MASKD, "<-> ctor");
    }

    public void analyze(ProblemAnalysisEvent event) {
        long unavailable;
        Trace.trace(TRACE_MASKD, "--> analyze()");
        MicroCodeDataEvent ourEvent = (MicroCodeDataEvent)event;
        Trace.trace(TRACE_MASKD, "Create a problem");
        CommonProblem aProblem = null;
        try {
            aProblem = this.instantiateProblem(ourEvent);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "<-- analyze: couldn't create problem: " + e);
            Log theLog = new Log(-86, 70, 0, "PA EVT DSCRD", null, null, null, null);
            String dataString = "couldn't create problem: " + e;
            theLog.add((byte)3, dataString);
            theLog.log();
            return;
        }
        HmcIncident anIncident = new HmcIncident();
        anIncident.setProblem(aProblem);
        Trace.trace(TRACE_MASKD, "Time of the incident = " + anIncident.getTimestamp().getTime());
        Trace.trace(TRACE_MASKD, "Add some stuff to the problem");
        aProblem.addProblemStatement(new BaseMessageText("XPA1641"));
        aProblem.addCorrectiveActionStatement(new BaseMessageText("XPA3027"));
        aProblem.addCorrectiveActionStatement(new BaseMessageText("XPA3002"));
        aProblem.addRepairImpactStatement(new BaseMessageText("XPA9990"));
        Log dataLog = (Log)ourEvent.getData();
        String byteOne = null;
        byteOne = dataLog.getLogClass() == 10 ? "a0" : HexString.toHex(dataLog.getLogClass(), true);
        byte[] logData = (byte[])dataLog.getLogBlock((byte)-16).getData();
        String refcode = byteOne + HexString.toHex(dataLog.getLogType(), true) + HexString.toHex(logData[1], true) + HexString.toHex(logData[0], true);
        refcode = refcode.toUpperCase();
        Trace.trace(TRACE_MASKD, "refcode to be set is =(" + refcode + ")");
        aProblem.setRefcode(refcode);
        String extension = ourEvent.getExtension();
        if (extension != null) {
            aProblem.setExtension(extension);
        } else {
            extension = "0000" + HexString.toHex(logData[3], true) + HexString.toHex(logData[2], true);
            aProblem.setExtension(extension.toUpperCase());
        }
        String secondaryExtension = ourEvent.getSecondaryExtension();
        if (secondaryExtension != null) {
            aProblem.setSecondaryExtension(secondaryExtension);
        }
        if (((unavailable = ourEvent.getUnavailableServices()) & 1L) != 0L) {
            aProblem.setSkipVPD(true);
        }
        if ((unavailable & 2L) != 0L) {
            aProblem.setSkipRSF(true);
        }
        anIncident.setPriority(40.0f);
        ConsoleAnalysisDomain cad = (ConsoleAnalysisDomain)DomainManager.getDomainManager().get(ConsoleAnalysisDomain.CAD_DOMAINID);
        this.reportIncident(ourEvent, anIncident, cad.getInitialTimeoutEvent(this), cad.getMicrocodeWait());
        Trace.trace(TRACE_MASKD, "<-- analyze()");
    }
}

